
;    UKI_Control UKI controller windows masm app
;    Copyright (C) 2010  NOP Security
;
;    This program is free software: you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation, either version 3 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program.  If not, see <http://www.gnu.org/licenses/>.

.386
.model flat,stdcall
option casemap:none

include UKIControl.inc

.code

AddEditControlText proc editctl:dword, strptr:dword
	LOCAL	tempy:dword
	
	.if editctl == 0 || strptr == NULL
		mov		eax, FALSE
		ret
	.endif
	
	invoke	SendDlgItemMessage, hWnd, editctl, EM_SETSEL, edtTxtLim, edtTxtLim
	invoke	SendDlgItemMessage, hWnd, editctl, EM_LINEINDEX, -1, 0
	add		eax, 800h 
	.if eax >= edtTxtLim
		and		tempy, 0
		invoke	SendDlgItemMessage, hWnd, editctl, EM_SETSEL, 0, 1000h
		invoke	SendDlgItemMessage, hWnd, editctl, EM_REPLACESEL, 0, addr tempy
		invoke	SendDlgItemMessage, hWnd, editctl, EM_SETSEL, edtTxtLim, edtTxtLim
	.endif
	invoke	SendDlgItemMessage, hWnd, editctl, EM_REPLACESEL, 0, strptr
	invoke	SendDlgItemMessage, hWnd, editctl, EM_SETSEL, edtTxtLim, edtTxtLim
	mov		eax, TRUE
	ret

AddEditControlText endp

HIDScanListConnect proc
	LOCAL	chrbuf[MAX_PATH]:byte
	LOCAL	guidbuf:GUID
	LOCAL	SP_DiD:SP_DEVICE_INTERFACE_DATA
	LOCAL	SP_DiDDtl:SP_DEVICE_INTERFACE_DATA_DETAIL
	LOCAL	HID_Attr:HIDD_ATTRIBUTES
	LOCAL	HID_Caps:HIDP_CAPS
	LOCAL	hDISet:dword
	LOCAL	tempx:dword
	LOCAL	tsize:dword
	LOCAL	vendidt:dword
	LOCAL	prodidt:dword
	LOCAL	hHIDFile:dword
	LOCAL	HIDVendID:dword
	LOCAL	HIDProdID:dword
	LOCAL	HIDVers:dword
	LOCAL	HIDPPDta:dword
	
	invoke	GetDlgItemText, hWnd, IDC_VENDID, addr chrbuf, MAX_PATH
	invoke	htodw, addr chrbuf
	mov		vendidt, eax
	invoke	GetDlgItemText, hWnd, IDC_PRODID, addr chrbuf, MAX_PATH
	invoke	htodw, addr chrbuf
	mov		prodidt, eax
	
	invoke	HidD_GetHidGuid, addr guidbuf
	
	invoke	SetupDiGetClassDevs, addr guidbuf, NULL, NULL, DIGCF_PRESENT or DIGCF_DEVICEINTERFACE
	.if eax == INVALID_HANDLE_VALUE
		invoke	GetLastError
		invoke	wsprintf, addr chrbuf, $CTA0("Fail handle: %08X\n"), eax
		invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
		xor		eax, eax
		ret
	.endif
	mov		hDISet, eax
	mov		SP_DiD.cbSize, sizeof(SP_DEVICE_INTERFACE_DATA)
	mov		SP_DiDDtl.cbSize, 5
	mov		HID_Attr._Size, sizeof HID_Attr
	mov		tempx, 0
	
	invoke	SetupDiEnumDeviceInterfaces, hDISet, NULL, addr guidbuf, tempx, addr SP_DiD
	.while eax == TRUE
		invoke	RtlZeroMemory, addr SP_DiDDtl.DevicePath, MAX_PATH
		
		invoke	SetupDiGetDeviceInterfaceDetail, hDISet, addr SP_DiD, addr SP_DiDDtl, sizeof(SP_DEVICE_INTERFACE_DATA_DETAIL), NULL, NULL
		.if eax == FALSE
			invoke	GetLastError
			.if eax == ERROR_INVALID_PARAMETER
				invoke	wsprintf, addr chrbuf, $CTA0("Error: Invalid Param\n")
			.elseif eax == ERROR_INVALID_USER_BUFFER
				invoke	wsprintf, addr chrbuf, $CTA0("Error: Invalid Buffer\n")
			.else
				invoke	wsprintf, addr chrbuf, $CTA0("Error: %08X\n"), eax
			.endif
			invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
		.else
			mov		HID_Attr.VendorID, 0
			mov		HID_Attr.ProductID, 0
			mov		HID_Attr.VersionNumber, 0
			
			invoke	wsprintf, addr chrbuf, $CTA0("Found: %s\n"), addr SP_DiDDtl.DevicePath
			invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf

			invoke	CreateFile, addr SP_DiDDtl.DevicePath, GENERIC_READ or GENERIC_WRITE, FILE_SHARE_READ or FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL
			mov		hHIDFile, eax
			.if eax != -1
				invoke	HidD_GetAttributes, hHIDFile, addr HID_Attr
				movzx	eax, HID_Attr.VendorID
				mov		HIDVendID, eax
				movzx	eax, HID_Attr.ProductID
				mov		HIDProdID, eax
				movzx	eax, HID_Attr.VersionNumber
				mov		HIDVers, eax
				invoke	wsprintf, addr chrbuf, $CTA0("VendID: %04X, ProdID: %04X, Vers: %04X\n"), HIDVendID, HIDProdID, HIDVers
				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
				invoke	HidD_GetPreparsedData, hHIDFile, addr HIDPPDta
				
				invoke	HidP_GetCaps, HIDPPDta, addr HID_Caps
				movzx	eax, HID_Caps.Usage
				invoke	wsprintf, addr chrbuf, $CTA0("Usage: %04X\n"), eax
				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
				movzx	eax, HID_Caps.UsagePage
				invoke	wsprintf, addr chrbuf, $CTA0("UsagePage: %04X\n"), eax
				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
				movzx	eax, HID_Caps.InputReportByteLength
				invoke	wsprintf, addr chrbuf, $CTA0("InputReportByteLength: %04X\n"), eax
				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
				movzx	eax, HID_Caps.OutputReportByteLength
				invoke	wsprintf, addr chrbuf, $CTA0("OutputReportByteLength: %04X\n"), eax
				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
				movzx	eax, HID_Caps.FeatureReportByteLength
				invoke	wsprintf, addr chrbuf, $CTA0("FeatureReportByteLength: %04X\n"), eax
				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
				
;				movzx	eax, HID_Caps.NumberLinkCollectionNodes  ;extra info
;				invoke	wsprintf, addr chrbuf, $CTA0("Linked Collection Nodes: %04X\n"), eax
;				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
;				movzx	eax, HID_Caps.NumberInputButtonCaps
;				invoke	wsprintf, addr chrbuf, $CTA0("Input Button Caps: %04X\n"), eax
;				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
;				movzx	eax, HID_Caps.NumberInputValueCaps
;				invoke	wsprintf, addr chrbuf, $CTA0("Input Value Caps: %04X\n"), eax
;				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
;				movzx	eax, HID_Caps.NumberInputDataIndices
;				invoke	wsprintf, addr chrbuf, $CTA0("Input Data Indices: %04X\n"), eax
;				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
;				movzx	eax, HID_Caps.NumberOutputButtonCaps
;				invoke	wsprintf, addr chrbuf, $CTA0("Output Button Caps: %04X\n"), eax
;				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
;				movzx	eax, HID_Caps.NumberOutputValueCaps
;				invoke	wsprintf, addr chrbuf, $CTA0("Output Value Caps: %04X\n"), eax
;				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
;				movzx	eax, HID_Caps.NumberOutputDataIndices
;				invoke	wsprintf, addr chrbuf, $CTA0("Output Data Indices: %04X\n"), eax
;				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
;				movzx	eax, HID_Caps.NumberFeatureButtonCaps
;				invoke	wsprintf, addr chrbuf, $CTA0("Feature Button Caps: %04X\n"), eax
;				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
;				movzx	eax, HID_Caps.NumberFeatureValueCaps
;				invoke	wsprintf, addr chrbuf, $CTA0("Feature Value Caps: %04X\n"), eax
;				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
;				movzx	eax, HID_Caps.NumberFeatureDataIndices
;				invoke	wsprintf, addr chrbuf, $CTA0("Feature Data Indices: %04X\n"), eax
;				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
				
				mov		eax, vendidt
				mov		ecx, prodidt
				.if HIDVendID == eax && HIDProdID == ecx
					invoke	wsprintf, addr chrbuf, $CTA0("Found\:  Connected\:\n")
					invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.if !hHIDev
						push	hHIDFile
						pop		hHIDev
					.endif
				.else
					invoke	CloseHandle, hHIDFile
				.endif
				invoke	HidD_FreePreparsedData, HIDPPDta
				
			.else
				invoke	GetLastError
				invoke	wsprintf, addr chrbuf, $CTA0("Error: %08X\n"), eax
				invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
			.endif
			
		.endif
		
		inc		tempx
		invoke	SetupDiEnumDeviceInterfaces, hDISet, NULL, addr guidbuf, tempx, addr SP_DiD
	.endw
	
	invoke	wsprintf, addr chrbuf, $CTA0("DeviceEnum Finished.\n")
	invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
	
	invoke	SetupDiDestroyDeviceInfoList, hDISet
	
	mov		eax, TRUE
	ret

HIDScanListConnect endp

UKICommand proc uses ebx hHID:DWORD, command:DWORD
	LOCAL	inbuf[3]:byte
	LOCAL	outbuf[5]:byte
	LOCAL	wrbyts:dword
	
	.if hHID == 0
		xor		eax, eax
		ret
	.endif
	
	invoke	RtlZeroMemory, addr inbuf, 3
	invoke	RtlZeroMemory, addr outbuf, 5
	mov		outbuf[0], 2
	mov		eax, command
	mov		outbuf[1], al
	mov		inbuf[0], 2
	
	invoke	WriteFile, hHID, addr outbuf, 5, addr wrbyts, NULL
	mov		inbuf[1], -1
	xor		ebx, ebx
	.while inbuf[1] != STATUSR_COMPLETE && inbuf[1] != STATUSR_IDLE && ebx < 200
		invoke	HidD_GetInputReport, hHID, addr inbuf, 3
		inc		ebx
	.endw
	.if inbuf[1] != STATUSR_COMPLETE
		xor		eax, eax
	.else
		mov		eax, TRUE
	.endif
	ret

UKICommand endp

UKIDownloadEEPROM proc uses ebx hHID:DWORD, p_outbuf:DWORD, buflen:DWORD
	LOCAL	inbuf[3]:byte
	LOCAL	outbuf[5]:byte
	LOCAL	count:dword
	LOCAL	wrbyts:dword
	
	.if hHID == 0
		xor		eax, eax
		ret
	.endif
	
	invoke	RtlZeroMemory, addr inbuf, 3
	invoke	RtlZeroMemory, addr outbuf, 5
	and		count, 0
	mov		outbuf[0], 2
	mov		outbuf[1], CONTROL_READ_EEBLOC
	mov		inbuf[0], 2
	
	xor		ecx, ecx
	.while ecx < buflen
		mov		eax, count
		mov		outbuf[2], al
		mov		outbuf[3], ah
		invoke	WriteFile, hHID, addr outbuf, 5, addr wrbyts, NULL
		mov		inbuf[1], -1
		xor		ebx, ebx
		.while inbuf[1] != STATUSR_COMPLETE && inbuf[1] != STATUSR_IDLE && ebx < 200
			invoke	HidD_GetInputReport, hHID, addr inbuf, 3
			.if !eax || inbuf[1] == STATUSR_EOF
				mov		eax, count
				ret
			.endif
			inc		ebx
		.endw
		.if inbuf[1] == STATUSR_COMPLETE
			mov		ecx, count
			mov		al, inbuf[2]
			mov		HID_EEBuf[ecx], al
		.endif
		inc		count
		mov		ecx, count
	.endw
	
	mov		eax, count
	ret

UKIDownloadEEPROM endp

UKIUploadEEPROM proc uses ebx hHID:DWORD, p_outbuf:DWORD, buflen:DWORD
	LOCAL	inbuf[3]:byte
	LOCAL	outbuf[5]:byte
	LOCAL	count:dword
	LOCAL	wrbyts:dword
	
	.if hHID == 0
		xor		eax, eax
		ret
	.endif
	
	invoke	RtlZeroMemory, addr inbuf, 3
	invoke	RtlZeroMemory, addr outbuf, 5
	and		count, 0
	mov		outbuf[0], 2
	mov		outbuf[1], CONTROL_WRITE_EEBLOC
	mov		inbuf[0], 2
	
	xor		ecx, ecx
	.while ecx < buflen
		mov		eax, count
		mov		outbuf[2], al
		mov		outbuf[3], ah
		mov		al, HID_EEBuf[eax]
		mov		outbuf[4], al
		invoke	WriteFile, hHID, addr outbuf, 5, addr wrbyts, NULL
		mov		inbuf[1], -1
		xor		ebx, ebx
		.while inbuf[1] != STATUSR_COMPLETE && inbuf[1] != STATUSR_IDLE && ebx < 200
			invoke	HidD_GetInputReport, hHID, addr inbuf, 3
			.if !eax || inbuf[1] == STATUSR_EOF
				mov		eax, count
				ret
			.endif
			inc		ebx
		.endw
		inc		count
		mov		ecx, count
	.endw
	
	mov		eax, count
	ret

UKIUploadEEPROM endp

ImportFileOpen proc
	LOCAL	ofnbuffer[MAX_PATH]:byte
	LOCAL	ofndata:OPENFILENAME
	LOCAL	hfile:dword
	LOCAL	readbyts:dword
	
	invoke	RtlZeroMemory, addr ofnbuffer, MAX_PATH
	invoke	RtlZeroMemory, addr ofndata, sizeof(OPENFILENAME)
	.if HID_EEBuf_Len >= sizeof HID_EEBuf
		invoke	AddEditControlText, IDC_MAINTXT, $CTA0("Not enough room in buffer.\n")
		xor		eax, eax
		ret
	.endif
	mov		ofndata.lStructSize, sizeof(OPENFILENAME)
	push	hWnd
	pop		ofndata.hwndOwner
	push	hInstance
	pop		ofndata.hInstance
	mov		ofndata.lpstrFilter, $CTA0("UKI Files\0*.uki\0All Files\0*.*\0")
	mov		ofndata.nFilterIndex, 1
	lea		eax, ofnbuffer
	mov		ofndata.lpstrFile, eax
	mov		ofndata.nMaxFile, MAX_PATH
	mov		ofndata.Flags, OFN_FILEMUSTEXIST or OFN_PATHMUSTEXIST or OFN_EXPLORER or OFN_HIDEREADONLY
	mov		ofndata.lpstrTitle, $CTA0("Select file to open")
	mov		ofndata.lpstrDefExt, $CTA0("uki")
	invoke	GetOpenFileName, addr ofndata
	.if eax == TRUE
		invoke	CreateFile, addr ofnbuffer, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL
		.if !eax
			invoke	AddEditControlText, IDC_MAINTXT, $CTA0("File open failed.\n")
			xor		eax, eax
			ret
		.endif
		mov		hfile, eax
		
		and		readbyts, 0
		mov		edx, offset HID_EEBuf
		add		edx, HID_EEBuf_Len
		mov		ecx, sizeof HID_EEBuf
		sub		ecx, HID_EEBuf_Len
		invoke	ReadFile, hfile, edx, ecx, addr readbyts, NULL
		.if !eax
			invoke	AddEditControlText, IDC_MAINTXT, $CTA0("File read failed.\n")
		.else
			mov		eax, readbyts
			add		HID_EEBuf_Len, eax
		.endif
		
		invoke	wsprintf, addr ofnbuffer, $CTA0("Read %d bytes.\n"), readbyts
		invoke	AddEditControlText, IDC_MAINTXT, addr ofnbuffer
		
		invoke	CloseHandle, hfile
	.else
		invoke	AddEditControlText, IDC_MAINTXT, $CTA0("Nothing selected.\n")
	.endif
	ret

ImportFileOpen endp

ExportFileSave proc
	LOCAL	ofnbuffer[MAX_PATH]:byte
	LOCAL	ofndata:OPENFILENAME
	LOCAL	hfile:dword
	LOCAL	wribyts:dword
	
	.if !HID_EEBuf_Len
		invoke	AddEditControlText, IDC_MAINTXT, $CTA0("Nothing in buffer to save.\n")
		xor		eax, eax
		ret
	.endif
	
	invoke	RtlZeroMemory, addr ofnbuffer, MAX_PATH
	invoke	RtlZeroMemory, addr ofndata, sizeof(OPENFILENAME)
	mov		ofndata.lStructSize, sizeof(OPENFILENAME)
	push	hWnd
	pop		ofndata.hwndOwner
	push	hInstance
	pop		ofndata.hInstance
	mov		ofndata.lpstrFilter, $CTA0("UKI Files\0*.uki\0All Files\0*.*\0")
	mov		ofndata.nFilterIndex, 1
	lea		eax, ofnbuffer
	mov		ofndata.lpstrFile, eax
	mov		ofndata.nMaxFile, MAX_PATH
	mov		ofndata.Flags, OFN_PATHMUSTEXIST or OFN_EXPLORER or OFN_HIDEREADONLY or OFN_OVERWRITEPROMPT
	mov		ofndata.lpstrTitle, $CTA0("Select file to open")
	mov		ofndata.lpstrDefExt, $CTA0("uki")
	invoke	GetSaveFileName, addr ofndata
	.if eax == TRUE
		invoke	CreateFile, addr ofnbuffer, GENERIC_WRITE, NULL, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL
		.if !eax
			invoke	AddEditControlText, IDC_MAINTXT, $CTA0("File open failed.\n")
			xor		eax, eax
			ret
		.endif
		mov		hfile, eax
		
		and		wribyts, 0
		mov		edx, offset HID_EEBuf
		add		edx, EECMDPTR_INIT
		mov		ecx, HID_EEBuf_Len
		sub		ecx, EECMDPTR_INIT
		invoke	WriteFile, hfile, edx, ecx, addr wribyts, NULL
		.if !eax
			invoke	AddEditControlText, IDC_MAINTXT, $CTA0("File write failed.\n")
		.endif
		
		invoke	wsprintf, addr ofnbuffer, $CTA0("Wrote %d bytes.\n"), wribyts
		invoke	AddEditControlText, IDC_MAINTXT, addr ofnbuffer
		
		invoke	CloseHandle, hfile
	.else
		invoke	AddEditControlText, IDC_MAINTXT, $CTA0("Nothing selected.\n")
	.endif
	ret

ExportFileSave endp

ConvertToControlCodes proc uses ebx esi edi p_ascii:dword, asciisz:dword, p_codes:dword, codesz:dword, curmod:dword
	LOCAL curptri:dword
	LOCAL curptro:dword
	LOCAL shifton:dword
	LOCAL doshift:dword
	LOCAL jushift:dword
	LOCAL lastcode:dword
	
	.if !p_ascii || !p_codes || !asciisz || !codesz
		xor		eax, eax
		ret
	.endif
	
	mov		esi, p_ascii
	mov		edi, p_codes
	mov		eax, p_ascii
	add		eax, asciisz
	mov		curptri, eax
	mov		eax, p_codes
	add		eax, codesz
	mov		curptro, eax
	and		shifton, 0
	and		doshift, 0
	and		lastcode, 0
	
	.while esi < curptri && edi < curptro
		mov		bl, byte ptr [esi]
		and		jushift, 0
		
		.if doshift
			mov		eax, edi
			inc		eax
			.if eax < curptro
				mov		byte ptr [edi], EECMD_STMODKEYS
				inc		edi
				xor		shifton, 2
				mov		eax, curmod
				and		al, 0FEh
				or		eax, shifton
				mov		byte ptr [edi], al
				inc		edi
				and		doshift, 0
				inc		jushift
			.else
				mov		byte ptr [edi], EECMD_END
				inc		edi
			.endif
		.elseif bl >= 'a' && bl <= 'z'
			.if shifton
				inc		doshift
			.else
				mov		al, bl
				sub		al, 'a'
				add		al, 4
				mov		byte ptr [edi], al
				inc		edi
			.endif
		.elseif bl >= 'A' && bl <= 'Z'
			.if !shifton
				inc		doshift
			.else
				mov		al, bl
				sub		al, 'A'
				add		al, 4
				mov		byte ptr [edi], al
				inc		edi
			.endif
		.elseif bl >= '0' && bl <= '9'
			.if shifton
				inc		doshift
			.else
				.if bl == '0'
					mov		byte ptr [edi], 027h
					inc		edi
				.else
					mov		al, bl
					sub		al, '1'
					add		al, 01Eh
					mov		byte ptr [edi], al
					inc		edi
				.endif
			.endif
		.elseif bl == '!'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 01Eh
				inc		edi
			.endif
		.elseif bl == '@'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 01Fh
				inc		edi
			.endif
		.elseif bl == '#'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 020h
				inc		edi
			.endif
		.elseif bl == '$'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 021h
				inc		edi
			.endif
		.elseif bl == '%'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 022h
				inc		edi
			.endif
		.elseif bl == '^'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 023h
				inc		edi
			.endif
		.elseif bl == '&'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 024h
				inc		edi
			.endif
		.elseif bl == '*'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 025h
				inc		edi
			.endif
		.elseif bl == '('
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 026h
				inc		edi
			.endif
		.elseif bl == ')'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 027h
				inc		edi
			.endif
		.elseif bl == 0Ah
			mov		byte ptr [edi], 028h
			inc		edi
		.elseif bl == 09h
			mov		byte ptr [edi], 02Bh
			inc		edi
		.elseif bl == ' '
			mov		byte ptr [edi], 02Ch
			inc		edi
		.elseif bl == '-'
			.if shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 02Dh
				inc		edi
			.endif
		.elseif bl == '_'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 02Dh
				inc		edi
			.endif
		.elseif bl == '='
			.if shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 02Eh
				inc		edi
			.endif
		.elseif bl == '+'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 02Eh
				inc		edi
			.endif
		.elseif bl == '['
			.if shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 02Fh
				inc		edi
			.endif
		.elseif bl == '{'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 02Fh
				inc		edi
			.endif
		.elseif bl == ']'
			.if shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 030h
				inc		edi
			.endif
		.elseif bl == '}'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 030h
				inc		edi
			.endif
		.elseif bl == '\'
			.if shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 031h
				inc		edi
			.endif
		.elseif bl == '|'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 031h
				inc		edi
			.endif
		.elseif bl == ';'
			.if shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 033h
				inc		edi
			.endif
		.elseif bl == ':'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 033h
				inc		edi
			.endif
		.elseif bl == "'"
			.if shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 034h
				inc		edi
			.endif
		.elseif bl == '"'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 034h
				inc		edi
			.endif
		.elseif bl == '`'
			.if shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 035h
				inc		edi
			.endif
		.elseif bl == '~'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 035h
				inc		edi
			.endif
		.elseif bl == ','
			.if shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 036h
				inc		edi
			.endif
		.elseif bl == '<'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 036h
				inc		edi
			.endif
		.elseif bl == '.'
			.if shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 037h
				inc		edi
			.endif
		.elseif bl == '>'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 037h
				inc		edi
			.endif
		.elseif bl == '/'
			.if shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 038h
				inc		edi
			.endif
		.elseif bl == '?'
			.if !shifton
				inc		doshift
			.else
				mov		byte ptr [edi], 038h
				inc		edi
			.endif
		.endif
		
		.if !doshift && !jushift
			movzx	eax, byte ptr [edi-1] 
			.if lastcode == eax && edi < curptro
				mov		byte ptr [edi], al
				mov		byte ptr [edi-1], 0
				inc		edi
			.else
				mov		lastcode, eax
			.endif
			inc		esi
		.endif
	.endw
	
	.if shifton && edi < curptro
		mov		eax, edi
		inc		eax
		.if eax < curptro
			mov		byte ptr [edi], EECMD_STMODKEYS
			inc		edi
			mov		eax, curmod
			mov		byte ptr [edi], al
			inc		edi
		.else
			mov		byte ptr [edi], EECMD_END
			inc		edi
		.endif
	.endif
	
	.if edi < curptro
		mov		byte ptr [edi], 0
		inc		edi
	.endif
	
	mov		eax, edi
	sub		eax, p_codes
	ret

ConvertToControlCodes endp

WinMain proc hInst:HINSTANCE,hPrevInst:HINSTANCE,CmdLine:LPSTR,CmdShow:DWORD
	LOCAL	wc:WNDCLASSEX
	LOCAL	msg:MSG

	mov		wc.cbSize,sizeof WNDCLASSEX
	mov		wc.style,CS_HREDRAW or CS_VREDRAW
	mov		wc.lpfnWndProc,offset WndProc
	mov		wc.cbClsExtra,NULL
	mov		wc.cbWndExtra,DLGWINDOWEXTRA
	push	hInst
	pop		wc.hInstance
	mov		wc.hbrBackground,COLOR_BTNFACE+1
	mov		wc.lpszMenuName,IDM_MENU
	mov		wc.lpszClassName,offset ClassName
	invoke LoadIcon,NULL,IDI_APPLICATION
	mov		wc.hIcon,eax
	mov		wc.hIconSm,eax
	invoke LoadCursor,NULL,IDC_ARROW
	mov		wc.hCursor,eax
	invoke RegisterClassEx,addr wc
	invoke CreateDialogParam,hInstance,IDD_DIALOG,NULL,addr WndProc,NULL
	invoke ShowWindow,hWnd,SW_SHOWNORMAL
	invoke UpdateWindow,hWnd
	.while TRUE
		invoke GetMessage,addr msg,NULL,0,0
	  .BREAK .if !eax
		invoke TranslateMessage,addr msg
		invoke DispatchMessage,addr msg
	.endw
	mov		eax,msg.wParam
	ret

WinMain endp

WndProc proc uses ebx hWin:HWND,uMsg:UINT,wParam:WPARAM,lParam:LPARAM
	LOCAL	chrbuf[MAX_PATH]:byte
	LOCAL	tempx:dword
	LOCAL	tsize:dword

	mov		eax,uMsg
	.if eax==WM_INITDIALOG
		push	hWin
		pop		hWnd
		and		hHIDev, 0
		invoke	SendDlgItemMessage, hWin, IDC_MAINTXT, EM_SETLIMITTEXT, 0, 0
		invoke	SendDlgItemMessage, hWin, IDC_MAINTXT, EM_GETLIMITTEXT, 0, 0
		sub		eax, 0100h
		mov		edtTxtLim, eax
		invoke	RtlZeroMemory, offset HID_EEBuf, sizeof HID_EEBuf
		invoke	RtlFillMemory, offset HID_EEBuf, EECMDPTR_INIT, 0FFh
		mov		HID_EEBuf_Len, EECMDPTR_INIT
		mov		curModifiers, 0
	.elseif eax==WM_COMMAND
		mov		eax,wParam
		mov		edx,wParam
		shr		edx, 16
		.if lParam == NULL
			.if	ax	== IDM_OPEN
				invoke	ImportFileOpen
			.elseif	ax	== IDM_SAVE
				invoke	ExportFileSave
			.elseif ax==IDM_FILE_EXIT
				invoke	SendMessage,hWin,WM_CLOSE,0,0
			.elseif ax==IDM_HELP_ABOUT
				invoke	MessageBox, hWin, offset AboutMsg, offset AppName, MB_OK
			.endif
		.else
			.if dx == BN_CLICKED
				.if ax == IDC_SCANCONN
					invoke	HIDScanListConnect
					.if eax
						invoke	wsprintf, addr chrbuf, $CTA0("HID scan complete.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.else
						invoke	wsprintf, addr chrbuf, $CTA0("HID scan error.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.endif
					xor		eax, eax
					ret
				.elseif ax == IDC_READHID
					.if !hHIDev
						invoke	HIDScanListConnect
					.endif
					.if !hHIDev
						invoke	wsprintf, addr chrbuf, $CTA0("UKI not connected.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
						xor		eax, eax
						ret
					.endif
					mov		injInBuf[0], 2
					invoke	HidD_GetInputReport, hHIDev, offset injInBuf, 3
					.if eax
						invoke	wsprintf, addr chrbuf, $CTA0("Status: %02X"), injInBuf[1]
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
						invoke	wsprintf, addr chrbuf, $CTA0(", %02X\n"), injInBuf[2]
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.else
						invoke	wsprintf, addr chrbuf, $CTA0("Read Fail\:\:\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.endif
				.elseif ax == IDC_TESTHID
					.if !hHIDev
						invoke	HIDScanListConnect
					.endif
					.if !hHIDev
						invoke	wsprintf, addr chrbuf, $CTA0("HID not connected.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
						xor		eax, eax
						ret
					.endif
					invoke	wsprintf, addr chrbuf, $CTA0("Attempting to blink 5 times.\n")
					invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					push	eax
					mov		eax, esp
					invoke	WriteFile, hHIDev, offset InitCode, 5, eax, NULL
					pop		ecx
					.if eax
						invoke	wsprintf, addr chrbuf, $CTA0("Write Succeed: %d bytes\n"), ecx
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.else
						invoke	wsprintf, addr chrbuf, $CTA0("Write Fail\:\:\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.endif
				.elseif ax == IDC_DLEEPROM
					.if !hHIDev
						invoke	HIDScanListConnect
					.endif
					.if !hHIDev
						invoke	wsprintf, addr chrbuf, $CTA0("HID not connected.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
						xor		eax, eax
						ret
					.endif
					invoke	wsprintf, addr chrbuf, $CTA0("Downloading EEPROM, please wait.\n")
					invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					invoke	UKIDownloadEEPROM, hHIDev, offset HID_EEBuf, 1024
					.if eax
						mov		HID_EEBuf_Len, eax
						invoke	wsprintf, addr chrbuf, $CTA0("Downloaded %d bytes.\n"), HID_EEBuf_Len
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.else
						invoke	wsprintf, addr chrbuf, $CTA0("Download Fail\:\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.endif
				.elseif ax == IDC_ULEEPROM
					.if !hHIDev
						invoke	HIDScanListConnect
					.endif
					.if !hHIDev
						invoke	wsprintf, addr chrbuf, $CTA0("HID not connected.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
						xor		eax, eax
						ret
					.endif
					invoke	wsprintf, addr chrbuf, $CTA0("Uploading EEPROM, please wait.\n")
					invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					invoke	UKIUploadEEPROM, hHIDev, offset HID_EEBuf, HID_EEBuf_Len
					.if eax
						invoke	wsprintf, addr chrbuf, $CTA0("Uploaded %d bytes.\n"), eax
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.else
						invoke	wsprintf, addr chrbuf, $CTA0("Upload Fail\:\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.endif
				.elseif ax == IDC_DUMPMEMHEX
					invoke	AddEditControlText, IDC_MAINTXT, $CTA0("Dumping Hex:\n")
					xor		ebx, ebx
					.while	ebx < HID_EEBuf_Len
						invoke	wsprintf, addr chrbuf, $CTA0("%02X "), HID_EEBuf[ebx]
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
						mov		ecx, ebx
						and		ecx, 01111b
						.if ecx ==  01111b
							invoke	wsprintf, addr chrbuf, $CTA0("\n")
							invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
						.endif
						inc		ebx
					.endw
					invoke	AddEditControlText, IDC_MAINTXT, $CTA0("\n")
					invoke	wsprintf, addr chrbuf, $CTA0("%d bytes output\n"), ebx
					invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
				.elseif ax == IDC_DISCHID
					.if !hHIDev
						invoke	HIDScanListConnect
					.endif
					.if !hHIDev
						invoke	wsprintf, addr chrbuf, $CTA0("HID not connected.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
						xor		eax, eax
						ret
					.endif
					invoke	CloseHandle, hHIDev
					and		hHIDev, 0
					invoke	wsprintf, addr chrbuf, $CTA0("HID Closed.\n")
					invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
				.elseif ax == IDC_CLEARMEM
					invoke	RtlZeroMemory, offset HID_EEBuf, sizeof HID_EEBuf
					invoke	RtlFillMemory, offset HID_EEBuf, EECMDPTR_INIT, 0FFh
					mov		HID_EEBuf_Len, EECMDPTR_INIT
					mov		curModifiers, 0
					invoke	wsprintf, addr chrbuf, $CTA0("Buffer cleared.\n")
					invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
				.elseif ax == IDC_CVTAPPEND
					invoke	GetDlgItemText, hWnd, IDC_INPUTTXT, offset edInputBuf, sizeof edInputBuf-1
					.if !eax
						invoke	wsprintf, addr chrbuf, $CTA0("Please enter text to convert.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
						xor eax, eax
						ret
					.endif
					mov		edInputBuf[eax], 0
					mov		ecx, offset HID_EEBuf
					add		ecx, HID_EEBuf_Len
					mov		edx, sizeof HID_EEBuf
					sub		edx, HID_EEBuf_Len
					invoke	ConvertToControlCodes, offset edInputBuf, eax, ecx, edx, curModifiers
					add		HID_EEBuf_Len, eax
					invoke	wsprintf, addr chrbuf, $CTA0("%d bytes appended to memory buffer for:\n"), eax
					invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					invoke	AddEditControlText, IDC_MAINTXT, offset edInputBuf
					invoke	AddEditControlText, IDC_MAINTXT, $CTA0("\n")
					invoke	SetDlgItemText, hWnd, IDC_INPUTTXT, $CTA0("")
				.elseif ax == IDC_APPENDFIN
					.if HID_EEBuf_Len < sizeof HID_EEBuf
						mov		eax, HID_EEBuf_Len
						mov		HID_EEBuf[eax], EECMD_END
						inc		HID_EEBuf_Len
						invoke	wsprintf, addr chrbuf, $CTA0("Fin appended to buffer.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.else
						invoke	wsprintf, addr chrbuf, $CTA0("Fin append failed.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.endif
				.elseif ax == IDC_APPENDNUL
					.if HID_EEBuf_Len < sizeof HID_EEBuf
						mov		eax, HID_EEBuf_Len
						mov		HID_EEBuf[eax], 0
						inc		HID_EEBuf_Len
						invoke	wsprintf, addr chrbuf, $CTA0("Null scancode appended to buffer.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.else
						invoke	wsprintf, addr chrbuf, $CTA0("Null scancode append failed.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.endif
				.elseif ax == IDC_APPENDRPT
					.if HID_EEBuf_Len < sizeof HID_EEBuf
						mov		eax, HID_EEBuf_Len
						mov		HID_EEBuf[eax], EECMD_RESTART
						inc		HID_EEBuf_Len
						invoke	wsprintf, addr chrbuf, $CTA0("Restart appended to buffer.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.else
						invoke	wsprintf, addr chrbuf, $CTA0("Restart append failed.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.endif
				.elseif ax == IDC_DISABLERUN
					.if !hHIDev
						invoke	HIDScanListConnect
					.endif
					.if !hHIDev
						invoke	wsprintf, addr chrbuf, $CTA0("HID not connected.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
						xor		eax, eax
						ret
					.endif
					invoke	UKICommand, hHIDev, CONTROL_DISABLE
					.if eax
						invoke	wsprintf, addr chrbuf, $CTA0("UKI Run Disabled.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.else
						invoke	wsprintf, addr chrbuf, $CTA0("Command Failed.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.endif
				.elseif ax == IDC_ENABLERUN
					.if !hHIDev
						invoke	HIDScanListConnect
					.endif
					.if !hHIDev
						invoke	wsprintf, addr chrbuf, $CTA0("HID not connected.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
						xor		eax, eax
						ret
					.endif
					invoke	UKICommand, hHIDev, CONTROL_ENABLE
					.if eax
						invoke	wsprintf, addr chrbuf, $CTA0("UKI Run Enabled.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.else
						invoke	wsprintf, addr chrbuf, $CTA0("Command Failed.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.endif
				.elseif ax == IDC_APPENDSECD || ax == IDC_APPENDMIND || ax == IDC_APPENDHRD
					movzx	ecx, ax
					mov		tempx, ecx
					.if HID_EEBuf_Len < (sizeof HID_EEBuf-1)
						invoke	GetDlgItemText, hWnd, IDC_INPUTTXT, offset edInputBuf, sizeof edInputBuf
						mov		edInputBuf[eax], 0
						invoke	atodw, offset edInputBuf
						.if eax > 254 || eax == 0
							invoke	wsprintf, addr chrbuf, $CTA0("No delay appended.\n")
							invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
							xor		eax, eax
							ret
						.endif
						mov		ebx, eax
						mov		eax, HID_EEBuf_Len
						.if tempx == IDC_APPENDSECD
							mov		HID_EEBuf[eax], EECMD_DELAYSEC
						.elseif tempx == IDC_APPENDMIND
							mov		HID_EEBuf[eax], EECMD_DELAYMIN
						.elseif tempx == IDC_APPENDHRD
							mov		HID_EEBuf[eax], EECMD_DELAYHR
						.endif
						inc		HID_EEBuf_Len
						mov		eax, HID_EEBuf_Len
						mov		HID_EEBuf[eax], bl
						inc		HID_EEBuf_Len
						.if tempx == IDC_APPENDSECD
							invoke	wsprintf, addr chrbuf, $CTA0("%d second delay appended to buffer.\n"), ebx
						.elseif tempx == IDC_APPENDMIND
							invoke	wsprintf, addr chrbuf, $CTA0("%d minute delay appended to buffer.\n"), ebx
						.elseif tempx == IDC_APPENDHRD
							invoke	wsprintf, addr chrbuf, $CTA0("%d hour delay appended to buffer.\n"), ebx
						.endif
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
						invoke	SetDlgItemText, hWnd, IDC_INPUTTXT, $CTA0("")
					.else
						invoke	wsprintf, addr chrbuf, $CTA0("Delay append failed.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					.endif
				.elseif ax == IDC_APPENDQD
					.if HID_EEBuf_Len < sizeof HID_EEBuf
						mov		eax, HID_EEBuf_Len
						mov		HID_EEBuf[eax], EECMD_DELAYQ
						inc		HID_EEBuf_Len
						invoke	AddEditControlText, IDC_MAINTXT, $CTA0("1 quarter second delay appended to buffer.\n")
					.else
						invoke	AddEditControlText, IDC_MAINTXT, $CTA0("Delay append failed.\n")
					.endif
				.elseif ax == IDC_DELBYTES
					invoke	GetDlgItemText, hWnd, IDC_INPUTTXT, offset edInputBuf, sizeof edInputBuf
					mov		edInputBuf[eax], 0
					invoke	atodw, offset edInputBuf
					.if eax >= HID_EEBuf_Len
						and		HID_EEBuf_Len, 0
					.elseif eax == 0
						invoke	wsprintf, addr chrbuf, $CTA0("No bytes removed.\n")
						invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
						xor		eax, eax
						ret
					.else
						sub		HID_EEBuf_Len, eax
					.endif
					invoke	wsprintf, addr chrbuf, $CTA0("%d bytes remain in buffer.\n"), HID_EEBuf_Len
					invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					invoke	SetDlgItemText, hWnd, IDC_INPUTTXT, $CTA0("")
				.elseif ax == IDC_SETMODS
					invoke	GetDlgItemText, hWnd, IDC_INPUTTXT, offset edInputBuf, sizeof edInputBuf
					.if !eax
						invoke	AddEditControlText, IDC_MAINTXT, $CTA0("Modifiers are written as 1 hex byte:\n")
						invoke	AddEditControlText, IDC_MAINTXT, $CTA0("Bit 0 (0x01): LeftControl\n")
						invoke	AddEditControlText, IDC_MAINTXT, $CTA0("Bit 1 (0x02): LeftShift\n")
						invoke	AddEditControlText, IDC_MAINTXT, $CTA0("Bit 2 (0x04): LeftAlt\n")
						invoke	AddEditControlText, IDC_MAINTXT, $CTA0("Bit 3 (0x08): Left GUI\n")
						invoke	AddEditControlText, IDC_MAINTXT, $CTA0("Bit 4 (0x10): RightControl\n")
						invoke	AddEditControlText, IDC_MAINTXT, $CTA0("Bit 5 (0x20): RightShift\n")
						invoke	AddEditControlText, IDC_MAINTXT, $CTA0("Bit 6 (0x40): RightAlt\n")
						invoke	AddEditControlText, IDC_MAINTXT, $CTA0("Bit 7 (0x80): Right GUI\n")
						xor		eax, eax
						ret
					.endif
					mov		edInputBuf[eax], 0
					invoke	htodw, offset edInputBuf
					mov		ebx, eax
					.if eax > 0FFh
						invoke	AddEditControlText, IDC_MAINTXT, $CTA0("Invalid modifier byte.\n")
						xor		eax, eax
						ret
					.endif
					.if ebx == curModifiers
						invoke	AddEditControlText, IDC_MAINTXT, $CTA0("No change.\n")
					.else
						mov		curModifiers, ebx
						.if HID_EEBuf_Len < sizeof HID_EEBuf-1
							mov		eax, HID_EEBuf_Len
							mov		HID_EEBuf[eax], EECMD_STMODKEYS
							inc		HID_EEBuf_Len
							mov		eax, HID_EEBuf_Len
							mov		HID_EEBuf[eax], bl
							inc		HID_EEBuf_Len
							invoke	wsprintf, addr chrbuf, $CTA0("Modifiers appended to buffer.\n")
							invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
						.else
							invoke	wsprintf, addr chrbuf, $CTA0("Modifier append failed.\n")
							invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
						.endif
					.endif
					invoke	wsprintf, addr chrbuf, $CTA0("Modifiers are set to %02X.\n"), curModifiers
					invoke	AddEditControlText, IDC_MAINTXT, addr chrbuf
					invoke	SetDlgItemText, hWnd, IDC_INPUTTXT, $CTA0("")
				.endif
			.endif
		.endif
	.elseif eax==WM_CLOSE
		.if hHIDev
			invoke	CloseHandle, hHIDev
		.endif
		invoke DestroyWindow,hWin
	.elseif uMsg==WM_DESTROY
		invoke PostQuitMessage,NULL
	.else
		invoke DefWindowProc,hWin,uMsg,wParam,lParam
		ret
	.endif
	xor    eax,eax
	ret

WndProc endp

start:

	invoke GetModuleHandle,NULL
	mov    hInstance,eax
	invoke GetCommandLine
	invoke InitCommonControls
	mov		CommandLine,eax
	invoke WinMain,hInstance,NULL,CommandLine,SW_SHOWDEFAULT
	invoke ExitProcess,eax

end start

