
;    UKI_Control UKI controller assembly example app
;    Copyright (C) 2010  NOP Security
;
;    This program is free software: you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation, either version 3 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program.  If not, see <http://www.gnu.org/licenses/>.

include windows.inc
include user32.inc
include kernel32.inc
include shell32.inc
include comctl32.inc
include comdlg32.inc
include hid.inc
include setupapi.inc
include masm32.inc

includelib user32.lib
includelib kernel32.lib
includelib shell32.lib
includelib comctl32.lib
includelib comdlg32.lib
includelib hid.lib
includelib setupapi.lib
includelib masm32.lib

include \masm32\macros\Strings.mac
include HID_Inj_Cmd.inc

DIGCF_PRESENT			equ 00000002h
DIGCF_DEVICEINTERFACE	equ 00000010h


SP_DEVICE_INTERFACE_DATA STRUCT
	cbSize				DWORD	?
	InterfaceClassGuid	GUID	<>
	Flags				DWORD	?
	Reserved			DWORD	?
SP_DEVICE_INTERFACE_DATA ENDS

SP_DEVICE_INTERFACE_DATA_DETAIL STRUCT
	cbSize				DWORD	?
	DevicePath			BYTE	MAX_PATH	dup(?)
SP_DEVICE_INTERFACE_DATA_DETAIL ENDS

HIDD_ATTRIBUTES STRUCT
  _Size					DWORD	?
  VendorID				WORD	?
  ProductID				WORD	?
  VersionNumber			WORD	?
HIDD_ATTRIBUTES ENDS

HIDP_CAPS STRUCT
  Usage							WORD	?
  UsagePage						WORD	?
  InputReportByteLength			WORD	?
  OutputReportByteLength		WORD	?
  FeatureReportByteLength		WORD	?
  Reserved						WORD	17	dup(?)
  NumberLinkCollectionNodes		WORD	?
  NumberInputButtonCaps			WORD	?
  NumberInputValueCaps			WORD	?
  NumberInputDataIndices		WORD	?
  NumberOutputButtonCaps		WORD	?
  NumberOutputValueCaps			WORD	?
  NumberOutputDataIndices		WORD	?
  NumberFeatureButtonCaps		WORD	?
  NumberFeatureValueCaps		WORD	?
  NumberFeatureDataIndices		WORD	?
HIDP_CAPS ENDS


WinMain				PROTO :DWORD,:DWORD,:DWORD,:DWORD
WndProc				PROTO :DWORD,:DWORD,:DWORD,:DWORD

;UKIControl.dlg
IDD_DIALOG						equ 1000
IDC_MAINTXT						equ 1001
IDC_SCANCONN					equ 1002
IDC_TESTHID						equ 1003
IDC_READHID						equ 1004
IDC_DISCHID						equ 1005
IDC_DLEEPROM					equ 1006
IDC_ULEEPROM					equ 1007
IDC_DUMPMEMHEX					equ 1008
IDC_PARSEMEM					equ 1009
IDC_CLEARMEM					equ 1010
IDC_INPUTTXT					equ 1011
IDC_CVTAPPEND					equ 1012
IDC_APPENDFIN					equ 1013
IDC_APPENDRPT					equ 1014
IDC_APPENDSECD					equ 1015
IDC_APPENDMIND					equ 1016
IDC_APPENDHRD					equ 1017
IDC_DELBYTES					equ 1018
IDC_SETMODS						equ 1019
IDC_DISABLERUN					equ 1020
IDC_ENABLERUN					equ 1021
IDC_APPENDNUL					equ 1022
IDC_APPENDQD					equ 1023
IDC_VENDID						equ 1024
IDC_PRODID						equ 1025
IDC_STC1						equ 1026
IDC_STC2						equ 1027

;UKIControl.mnu
IDM_MENU						equ 10000
IDM_OPEN						equ 10002
IDM_SAVE						equ 10003
IDM_FILE_EXIT					equ 10001
IDM_HELP_ABOUT					equ 10101

.const

ClassName			db 'HIDDLGCTRL',0
AppName				db 'UKIControl',0
AboutMsg			db 'UKI Controller',13,10,'Copyright  2010 NOP Security',0
InitCode			db  2, CONTROL_BLINK, 5, 0, 0

.data?

hInstance			dd ?
CommandLine			dd ?
hWnd				dd ?
edtTxtLim			dd ?
injInBuf			db 16 dup(?)
hHIDev				dd ?
HID_EEBuf			db 1024 dup(?)
HID_EEBuf_Len		dd ?
edInputBuf			db 1024 dup(?)
curModifiers		dd ?
